/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.service.serviceaction.repair.effectors;

import com.ibm.hwmca.fw.pa.problem.Problem;
import com.ibm.hwmca.fw.pa.problem.ProblemManager;
import com.ibm.hwmca.fw.pa.problem.history.HistoryEntry;
import com.ibm.hwmca.fw.service.panel.GenericGui;
import com.ibm.hwmca.fw.service.serviceaction.ServiceActionType;
import com.ibm.hwmca.fw.service.statetransition.Context;
import com.ibm.hwmca.fw.service.statetransition.Effector;
import com.ibm.hwmca.fw.service.statetransition.EffectorException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.p.service.serviceaction.repair.PIEndOfCall;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import com.ibm.hwmca.xfw.service.SD;
import com.ibm.hwmca.xfw.service.panel.PBCommonEnterRepairDescription;
import com.ibm.hwmca.xfw.service.panel.PBCommonProblemClose;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PICloseProblems
implements Effector {
    private static final String TRACE_MASKT = "XRVDTMST";
    private static final String TRACE_MASKF = "XRVDTMSF";
    private static final String TRACE_MASKD = "XRVDTMSD";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fire(Context context) throws EffectorException {
        Trace.trace(TRACE_MASKT, "-> PICloseProblems.fire");
        Map userData = context.getUserData();
        GenericGui guiHandle = (GenericGui)userData.get("DISPLAY_HANDLE");
        try {
            context.getVariable(SD.OVERALL_STATUS_VARIABLE).setValue(SD.CONTINUE);
            ProblemManager pm = ProblemManager.getProblemManager();
            CommonProblem cp = (CommonProblem)userData.get("PROBLEM");
            PBCommonEnterRepairDescription rdbean = new PBCommonEnterRepairDescription();
            rdbean = (PBCommonEnterRepairDescription)guiHandle.replace("com.ibm.hwmca.fw.service.panel.res.CommonPanels", rdbean.getTemplateName(), rdbean, userData);
            String fixDesc = rdbean.getEditBoxText();
            cp.addFixDescription(fixDesc == null ? "" : fixDesc);
            cp.addCeComments("", fixDesc == null ? "" : fixDesc);
            String serviceActionType = (String)userData.get("rvType");
            if (serviceActionType.equals(ServiceActionType.REPAIR_PROBLEM.getValue()) || serviceActionType.equals(ServiceActionType.REPLACE_FRU.getValue())) {
                List problems = pm.getAllProblems();
                if (problems != null) {
                    Problem p;
                    ArrayList<Problem> listOfOne = new ArrayList<Problem>(1);
                    ArrayList<CommonProblem> duplicates = new ArrayList<CommonProblem>();
                    duplicates.add(cp);
                    Iterator it = problems.iterator();
                    while (it.hasNext()) {
                        p = (Problem)it.next();
                        if (p == cp || p.getProblemState() != 1) continue;
                        listOfOne.clear();
                        listOfOne.add(p);
                    }
                    it = duplicates.iterator();
                    while (it.hasNext()) {
                        p = (Problem)it.next();
                        try {
                            pm.close(p);
                        }
                        catch (Exception e) {
                            try {
                                Trace.trace(TRACE_MASKF, "CloseProblems.fire exception closing duplicate problem ignored, problem=[" + p + "]");
                            }
                            catch (Exception e2) {
                                Trace.trace(TRACE_MASKF, "Exception caught on trace of 'p':" + e2);
                            }
                        }
                    }
                }
                PBCommonProblemClose pcbean = new PBCommonProblemClose();
                pcbean = (PBCommonProblemClose)guiHandle.replace("com.ibm.hwmca.fw.service.panel.res.CommonPanels", pcbean.getTemplateName(), pcbean, userData);
            }
            try {
                try {
                    guiHandle.showBusyDialog(new LocalizableText("End of service action processing"), new LocalizableText("End of service action processing in progress.  Please wait."), userData);
                }
                catch (Exception toss) {
                    // empty catch block
                }
                try {
                    ProblemManager.getProblemManager().close(cp);
                }
                catch (Exception toss) {
                    try {
                        Trace.trace(TRACE_MASKF, "CloseProblems.fire exception closing problem ignored, problem=[" + cp + "]");
                    }
                    catch (Exception e2) {
                        Trace.trace(TRACE_MASKF, "Exception caught on trace of 'cp':" + e2);
                    }
                }
                try {
                    PIEndOfCall.endOfCallProcessing(userData);
                }
                catch (Exception e2) {
                    Trace.trace(TRACE_MASKF, "Exception caught on endOfCallProcessing of 'userData':" + e2);
                }
                cp.serviceHistoryEvent(new HistoryEntry(9));
            }
            finally {
                try {
                    guiHandle.destroyBusyDialog(userData);
                }
                catch (Exception toss) {}
            }
            Trace.trace(TRACE_MASKT, "<- PICloseProblems.fire");
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-! PICloseProblems.fire, exception caught: " + e);
            Trace.trace(TRACE_MASKT, e);
            throw new EffectorException(e);
        }
    }
}

